<?php
/**
 * Lets Review options
 *
 * @package     Lets Review
 * @copyright   Copyright Codetipi
 * @since       3.0.0
 */
class Lets_Review_Options {

	/**
	 * Options
	 *
	 * @since    3.0.0
	 */
	static $lets_review_options;

	/**
	 * Options getter
	 *
	 * @since    3.0.0
	 */
	static function lets_review_get_option( $option = 'lets_review' ) {

		self::$lets_review_options = get_option( $option, array() );

	}

	static function lets_review_set_user_ratings() {
		self::$lets_review_options = empty( self::$lets_review_options ) ? array() : self::$lets_review_options;
		self::$lets_review_options['lets_review_user_ratings'] = empty( self::$lets_review_options['lets_review_user_ratings'] ) ? array() : self::$lets_review_options['lets_review_user_ratings'];
	}

	static function lets_review_set_up_down() {
		self::$lets_review_options = empty( self::$lets_review_options ) ? array() : self::$lets_review_options;
		self::$lets_review_options['lets_review_up_down'] = empty( self::$lets_review_options['lets_review_up_down'] ) ? array() : self::$lets_review_options['lets_review_up_down'];
	}

	/**
	 * Options setter
	 *
	 * @since    3.0.0
	 */
	static function lets_review_update_option() {

		$options = self::lets_review_sanitized();
		update_option( 'lets_review', $options );
		self::$lets_review_options = get_option( 'lets_review' );

	}

	/**
	 * User Ratings
	 *
	 * @since    3.0.0
	 */
	static function lets_review_get_user_ratings() {

		$output = empty( self::$lets_review_options['lets_review_user_ratings'] ) ? array() : self::$lets_review_options['lets_review_user_ratings'];

		return $output;

	}

	/**
	 * Options sanitizer
	 *
	 * @since    3.0.0
	 */
	private static function lets_review_sanitized( $option = '' ) {

		$option = empty( $option ) ? self::$lets_review_options : $option;
		$sanitized_array = array();

		if ( ! is_array( $option ) ) {
			return array();
		}
		foreach ( $option as $key => $value ) {

			if ( ! is_array( $value ) && ! is_object( $value ) ) {
				$sanitized_array[ esc_html( $key ) ] = esc_attr( $value );
			}

			if ( is_array( $value ) && ! empty( $value ) ) {
				$sanitized_array[ esc_html( $key ) ] = self::lets_review_sanitized( $value );
			}
		}

		return $sanitized_array;
	}

}

Lets_Review_Options::lets_review_get_option();
